VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cTreeViewNodes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private m_lIDParent As Long
Private m_hWndCtl As Long

Private Function pbVerify(ByRef ctlThis As vbalTreeView) As Boolean
Dim lPtr As Long
Dim lIdx As Long
   If IsWindow(m_hWndCtl) Then
      lPtr = GetProp(m_hWndCtl, gcOBJECT_PROP)
      If Not (lPtr = 0) Then
         
         If (lPtr = 1) Then
            Debug.Print "NOOOOOO"
         End If
         
         Set ctlThis = ObjectFromPtr(lPtr)
         pbVerify = True
      Else
         gErr 1, "cListItems"
      End If
   Else
      gErr 1, "cListItems"
   End If
End Function

Friend Sub fInit(ctl As vbalTreeView, ByVal lIDParent As Long)
   m_lIDParent = lIDParent
   m_hWndCtl = ctl.hwnd
End Sub

Public Function Add( _
      Optional ByVal Relative As cTreeViewNode = Nothing, _
      Optional ByVal RelationShip As ETreeViewRelationshipContants = etvwChild, _
      Optional ByVal Key As String = "", _
      Optional ByVal Text As String = "", _
      Optional ByVal Image As Long = -1, _
      Optional ByVal SelectedImage As Long = -1 _
   ) As cTreeViewNode
Attribute Add.VB_Description = "Adds a new node with the specified relation to the node which owns this collection."
Dim ctl As vbalTreeView
Dim lIDRel As Long
Dim lIDNew As Long
Dim nodRet As cTreeViewNode
   If (pbVerify(ctl)) Then
      If (Relative Is Nothing) Then
         lIDRel = m_lIDParent
      Else
         lIDRel = Relative.ID
      End If
      lIDNew = ctl.fAdd(lIDRel, RelationShip, Key, Text, Image, SelectedImage)
      If Not (lIDNew = 0) Then
         Set nodRet = New cTreeViewNode
         nodRet.fInit ctl, lIDNew
         Set Add = nodRet
      End If
   End If
End Function

Public Sub Clear()
Attribute Clear.VB_Description = "Clears all the nodes from this collection."
Dim ctl As vbalTreeView
   If (pbVerify(ctl)) Then
      If (m_lIDParent = 0) Then
         ctl.fRemoveAll
      Else
         ctl.fRemoveChildren m_lIDParent
      End If
   End If
   '
End Sub

Public Property Get Count() As Long
Attribute Count.VB_Description = "Gets the number of nodes in this collection."
Dim ctl As vbalTreeView
   If (pbVerify(ctl)) Then
      Count = ctl.fCount(m_lIDParent)
   End If
End Property

Public Property Get Item(Index As Variant) As cTreeViewNode
Attribute Item.VB_Description = "Gets the item with the specified Key or index within the collection."
Attribute Item.VB_UserMemId = 0
Dim ctl As vbalTreeView
Dim lID As Long
   If (pbVerify(ctl)) Then
      If (m_lIDParent = 0) Or Not IsNumeric(Index) Then
         lID = ctl.fIDForIndex(Index)
      Else
         lID = ctl.fIDForNumericIndexInSubTree(m_lIDParent, Index)
      End If
      If Not (lID = 0) Then
         Dim cItem As New cTreeViewNode
         cItem.fInit ctl, lID
         Set Item = cItem
      End If
   End If
End Property

Public Sub Remove(Index As Variant)
Attribute Remove.VB_Description = "Removes the item with the specified index or key."
Dim ctl As vbalTreeView
Dim lID As Long
   If (pbVerify(ctl)) Then
      If Not IsNumeric(Index) Then
         lID = ctl.fIDForIndex(Index)
      Else
         lID = ctl.fIDForNumericIndexInSubTree(m_lIDParent, Index)
      End If
      If Not (lID = 0) Then
         ctl.fRemove lID
      End If
   End If
End Sub

Public Function Exists(Index As Variant) As Boolean
Attribute Exists.VB_Description = "Returns true if the item with the specified key exists in the collection or not."
Dim ctl As vbalTreeView
Dim lID As Long
Dim lErr As Long
   If (pbVerify(ctl)) Then
      On Error Resume Next
      lID = ctl.fIDForIndex(Index)
      lErr = Err.Number
      On Error GoTo 0
      Exists = ((lID <> 0) And (lErr = 0))
   End If
End Function

Public Property Get Parent() As cTreeViewNode
Attribute Parent.VB_Description = "Gets the parent of this node collection, if any, otherwise returns Nothing if it contains the root items in the tree."
Dim ctl As vbalTreeView
   If (pbVerify(ctl)) Then
      If Not (m_lIDParent = 0) Then
         If Not (ctl.fhItemForID(m_lIDParent) = 0) Then
            Dim cNod As New cTreeViewNode
            cNod.fInit ctl, m_lIDParent
            Set Parent = cNod
         End If
      End If
   End If
End Property
