VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cTreeViewNode"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private m_lID As Long
Private m_ptrCtl As Long
Private m_hWndCtl As Long

Private Function pbVerify(ByRef ctlThis As vbalTreeView) As Boolean
Dim lPtr As Long
Dim lIdx As Long
   If IsWindow(m_hWndCtl) Then
      lPtr = GetProp(m_hWndCtl, gcOBJECT_PROP)
      If Not (lPtr = 0) Then
         If (lPtr = 1) Then
            Debug.Print "NOOOOOO"
         End If
         Set ctlThis = ObjectFromPtr(lPtr)
         If (ctlThis.fhItemForID(m_lID)) Then
            pbVerify = True
         End If
      Else
         gErr 1, "cListItems"
      End If
   Else
      gErr 1, "cListItems"
   End If
End Function

Friend Sub fInit(ctl As vbalTreeView, ByVal lID As Long)
   m_lID = lID
   m_ptrCtl = ObjPtr(ctl)
   m_hWndCtl = ctl.hwnd
End Sub
Friend Property Get fID() As Long
   fID = m_lID
End Property

Public Function IsParentOf(nodeCheck As cTreeViewNode) As Boolean
Attribute IsParentOf.VB_Description = "Returns True if the specified node is a parent of this node, otherwise False."
Dim ctl As vbalTreeView
Dim lIDCheck As Long
Dim bIsParent As Boolean
   If (pbVerify(ctl)) Then
      If Not (nodeCheck Is Nothing) Then
         lIDCheck = nodeCheck.fID
         Do While Not (lIDCheck = 0)
            If (lIDCheck = m_lID) Then
               bIsParent = True
               Exit Do
            End If
            lIDCheck = ctl.fItemParent(lIDCheck)
         Loop
      End If
      IsParentOf = bIsParent
   End If
End Function

Public Sub MoveNode( _
      nodeRelative As cTreeViewNode, _
      Optional ByVal eRelationship As ETreeViewRelationshipContants = etvwNext _
   )
Attribute MoveNode.VB_Description = "Moves this node to another location in the TreeView."
Dim lIDNew As Long
Dim ctl As vbalTreeView
   If (pbVerify(ctl)) Then
      lIDNew = ctl.fMoveNode(m_lID, nodeRelative, eRelationship)
      m_lID = lIDNew
   End If
End Sub

Public Function InsertNodeBefore( _
      Optional ByVal Key As String = "", _
      Optional ByVal Text As String = "", _
      Optional ByVal Image As Long = -1, _
      Optional ByVal SelectedImage As Long = -1 _
   ) As cTreeViewNode
Attribute InsertNodeBefore.VB_Description = "Inserts a new node before this node."
Dim ctl As vbalTreeView
   If (pbVerify(ctl)) Then
      Dim lIDNew As Long
      lIDNew = ctl.fAdd(m_lID, etvwPrevious, Key, Text, Image, SelectedImage)
      If Not (lIDNew = 0) Then
         Dim nodRet As New cTreeViewNode
         nodRet.fInit ctl, lIDNew
         Set AddChildNode = nodRet
      End If
   End If
End Function
Public Function InsertNodeAfter( _
      Optional ByVal Key As String = "", _
      Optional ByVal Text As String = "", _
      Optional ByVal Image As Long = -1, _
      Optional ByVal SelectedImage As Long = -1 _
   ) As cTreeViewNode
Attribute InsertNodeAfter.VB_Description = "Inserts a new node after this node."
Dim ctl As vbalTreeView
   If (pbVerify(ctl)) Then
      Dim lIDNew As Long
      lIDNew = ctl.fAdd(m_lID, etvwNext, Key, Text, Image, SelectedImage)
      If Not (lIDNew = 0) Then
         Dim nodRet As New cTreeViewNode
         nodRet.fInit ctl, lIDNew
         Set AddChildNode = nodRet
      End If
   End If
End Function
Public Function AddChildNode( _
      Optional ByVal Key As String = "", _
      Optional ByVal Text As String = "", _
      Optional ByVal Image As Long = -1, _
      Optional ByVal SelectedImage As Long = -1 _
   ) As cTreeViewNode
Attribute AddChildNode.VB_Description = "Adds a child node to this node."
Dim ctl As vbalTreeView
   If (pbVerify(ctl)) Then
      Dim lIDNew As Long
      lIDNew = ctl.fAdd(m_lID, etvwChild, Key, Text, Image, SelectedImage)
      If Not (lIDNew = 0) Then
         Dim nodRet As New cTreeViewNode
         nodRet.fInit ctl, lIDNew
         Set AddChildNode = nodRet
      End If
   End If
End Function

Public Property Get Owner() As vbalTreeView
Attribute Owner.VB_Description = "Gets the owning control for this item.  Note that this returns the control itself, not the control's extender."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Set Owner = ctl
   End If
End Property

Public Property Get hItem() As Long
Attribute hItem.VB_Description = "Gets the API handle of this item within the TreeView."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      hItem = ctl.fhItemForID(m_lID)
   End If
End Property

Friend Property Get ID() As Long
   ID = m_lID
End Property

Public Property Get BackColor() As OLE_COLOR
Attribute BackColor.VB_Description = "Gets/sets the background colour of this node. Only applied if the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      BackColor = ctl.fItemBackColor(m_lID)
   End If
End Property
Public Property Let BackColor(ByVal value As OLE_COLOR)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemBackColor(m_lID) = value
   End If
End Property

Public Property Get SelectedBackColor() As OLE_COLOR
Attribute SelectedBackColor.VB_Description = "Gets/sets the selected background colour of this node. Only applied if the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      SelectedBackColor = ctl.fItemSelectedBackColor(m_lID)
   End If
End Property
Public Property Let SelectedBackColor(ByVal value As OLE_COLOR)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemSelectedBackColor(m_lID) = value
   End If
End Property

Public Property Get SelectedNoFocusBackColor() As OLE_COLOR
Attribute SelectedNoFocusBackColor.VB_Description = "Gets/sets the selected background colour of this node when the mouse is over it and the control is out of focus. Only applied if the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      SelectedBackColor = ctl.fItemSelectedNoFocusBackColor(m_lID)
   End If
End Property
Public Property Let SelectedNoFocusBackColor(ByVal value As OLE_COLOR)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemSelectedNoFocusBackColor(m_lID) = value
   End If
End Property

Public Property Get SelectedMouseOverBackColor() As OLE_COLOR
Attribute SelectedMouseOverBackColor.VB_Description = "Gets/sets the selected background colour of this node when the mouse is over it. Only applied if the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      SelectedBackColor = ctl.fItemSelectedMouseOverBackColor(m_lID)
   End If
End Property
Public Property Let SelectedMouseOverBackColor(ByVal value As OLE_COLOR)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemSelectedMouseOverBackColor(m_lID) = value
   End If
End Property

Public Property Get MouseOverBackColor() As OLE_COLOR
Attribute MouseOverBackColor.VB_Description = "Gets/sets the background colour of this node when the mouse is over it. Only applied if the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      MouseOverBackColor = ctl.fItemMouseOverBackColor(m_lID)
   End If
End Property
Public Property Let MouseOverBackColor(ByVal value As OLE_COLOR)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemMouseOverBackColor(m_lID) = value
   End If
End Property


Public Property Get Bold() As Boolean
Attribute Bold.VB_Description = "Gets/sets whether this node is rendered with a bold font."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Bold = ctl.fItemBold(m_lID)
   End If
End Property
Public Property Let Bold(ByVal value As Boolean)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemBold(m_lID) = value
   End If
End Property

Public Property Get NoCheckBox() As Boolean
Attribute NoCheckBox.VB_Description = "Gets/sets whether this item should hide the check box when the TreeView has the CheckBoxes property set."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      NoCheckBox = ctl.fItemNoCheckBox(m_lID)
   End If
End Property

Public Property Let NoCheckBox(ByVal value As Boolean)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemNoCheckBox(m_lID) = value
   End If
End Property

Public Property Get Checked() As Boolean
Attribute Checked.VB_Description = "Gets/sets whether this node is checked or not."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Checked = ctl.fItemChecked(m_lID)
   End If
End Property
Public Property Let Checked(ByVal value As Boolean)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemChecked(m_lID) = value
   End If
End Property

Public Property Get FirstChild() As cTreeViewNode
Attribute FirstChild.VB_Description = "Gets the first child node of this node, if any, otherwise returns Nothing."
Dim ctl As vbalTreeView
Dim lIDChild As Long
   If pbVerify(ctl) Then
      lIDChild = ctl.fItemChild(m_lID)
      If Not (lIDChild = 0) Then
         Dim cNode As New cTreeViewNode
         cNode.fInit ctl, lIDChild
         Set FirstChild = cNode
      End If
   End If
End Property

Public Property Get Children() As cTreeViewNodes
Attribute Children.VB_Description = "Gets the collection of children associated with this node."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Dim cNodes As New cTreeViewNodes
      cNodes.fInit ctl, m_lID
      Set Children = cNodes
   End If
End Property

Public Property Get DropHighlighted() As Boolean
Attribute DropHighlighted.VB_Description = "Gets/sets whether this node is drop-highlighted or not."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      DropHighlighted = ctl.fItemDropHighlight(m_lID)
   End If
End Property
Public Property Let DropHighlighted(ByVal value As Boolean)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemDropHighlight(m_lID) = value
   End If
End Property

Public Sub EnsureVisible()
Attribute EnsureVisible.VB_Description = "Brings this node into view if it is not currently visible."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemEnsureVisible m_lID
   End If
End Sub

Public Property Get Expanded() As Boolean
Attribute Expanded.VB_Description = "Gets/sets whether this node is expanded or not."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Expanded = ctl.fItemExpanded(m_lID)
   End If
End Property
Public Property Let Expanded(ByVal value As Boolean)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemExpanded(m_lID) = value
   End If
End Property

Public Property Get FirstSibling() As cTreeViewNode
Attribute FirstSibling.VB_Description = "Gets the first sibling of this node."
Dim ctl As vbalTreeView
Dim lIDParent As Long
Dim lIDChild As Long
   If pbVerify(ctl) Then
      lIDParent = ctl.fItemParent(m_lID)
      Dim cNod As New cTreeViewNode
      If Not (lIDParent = 0) Then
         lIDChild = ctl.fItemChild(lIDParent)
         If Not (lIDChild = 0) Then
            cNod.fInit ctl, m_lID
            Set FirstSibling = cNod
         End If
      Else
         ' I am my own first sibling:
         cNod.fInit ctl, m_lID
         Set FirstSibling = cNod
      End If
   End If
End Property

Public Property Get ForeColor() As OLE_COLOR
Attribute ForeColor.VB_Description = "Gets/sets the foreground colour of this node. Only applied if the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ForeColor = ctl.fItemForeColor(m_lID)
   End If
End Property
Public Property Let ForeColor(ByVal value As OLE_COLOR)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemForeColor(m_lID) = value
   End If
End Property

Public Property Get SelectedForeColor() As OLE_COLOR
Attribute SelectedForeColor.VB_Description = "Gets/sets the selected foreground colour of this node. Only applied if the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      SelectedForeColor = ctl.fItemSelectedColor(m_lID)
   End If
End Property
Public Property Let SelectedForeColor(ByVal value As OLE_COLOR)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemSelectedColor(m_lID) = value
   End If
End Property

Public Property Get SelectedNoFocusForeColor() As OLE_COLOR
Attribute SelectedNoFocusForeColor.VB_Description = "Gets/sets the selected foreground colour of this node when the mouse is over it and the control is out of focus. Only applied if the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      SelectedForeColor = ctl.fItemSelectedNoFocusColor(m_lID)
   End If
End Property
Public Property Let SelectedNoFocusForeColor(ByVal value As OLE_COLOR)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemSelectedNoFocusColor(m_lID) = value
   End If
End Property

Public Property Get MouseOverForeColor() As OLE_COLOR
Attribute MouseOverForeColor.VB_Description = "Gets/sets the foreground colour of this node when the mouse is over it. Only applied if the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      MouseOverForeColor = ctl.fItemMouseOverColor(m_lID)
   End If
End Property
Public Property Let MouseOverForeColor(ByVal value As OLE_COLOR)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemMouseOverColor(m_lID) = value
   End If
End Property

Public Property Get SelectedMouseOverForeColor() As OLE_COLOR
Attribute SelectedMouseOverForeColor.VB_Description = "Gets/sets the selected foreground colour of this node when the mouse is over it. Only applied if the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      SelectedForeColor = ctl.fItemSelectedMouseOverColor(m_lID)
   End If
End Property
Public Property Let SelectedMouseOverForeColor(ByVal value As OLE_COLOR)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemSelectedMouseOverColor(m_lID) = value
   End If
End Property


Public Property Get Font() As IFont
Attribute Font.VB_Description = "Gets/sets the Font used to render this node.  Only applied when the control's NoCustomDraw property is False."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Set Font = ctl.fItemFont(m_lID)
   End If
End Property
Public Property Let Font(iFnt As IFont)
   pSetFont iFnt
End Property
Public Property Set Font(iFnt As IFontDisp)
   pSetFont iFnt
End Property
Private Sub pSetFont(iFnt As IFontDisp)
   Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Set ctl.fItemFont(m_lID) = iFnt
   End If
End Sub

Public Property Get FullPath() As String
Attribute FullPath.VB_Description = "Gets the Full Path of this item in the tree."
   Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      FullPath = ctl.fItemPath(m_lID)
   End If
End Property

Public Property Get Image() As Long
Attribute Image.VB_Description = "Gets/sets the 0-based index of the image in the TreeView's image list to use."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Image = ctl.fItemImage(m_lID)
   End If
End Property
Public Property Let Image(ByVal value As Long)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemImage(m_lID) = value
   End If
End Property

Public Property Get ItemData() As Long
Attribute ItemData.VB_Description = "Gets/sets a long value associated with this node."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ItemData = ctl.fItemData(m_lID)
   End If
End Property
Public Property Let ItemData(ByVal value As Long)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemData(m_lID) = value
   End If
End Property

Public Property Get ItemNumber() As Long
Attribute ItemNumber.VB_Description = "Gets/sets a number which is displayed next to this node when the TreeView has the ShowNumbers property set.  Set to -1 for no number."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ItemNumber = ctl.fItemNumber(m_lID)
   End If
End Property
Public Property Let ItemNumber(ByVal value As Long)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemNumber(m_lID) = value
   End If
End Property

Public Property Get Index() As Long
Attribute Index.VB_Description = "Gets the index of this item within its tree."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Index = ctl.fNumericIndexInSubTree(m_lID)
   End If
End Property

Public Property Get Key() As String
Attribute Key.VB_Description = "Gets/sets the string key used to refer to this item. Must be unique."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Key = ctl.fItemKey(m_lID)
   End If
End Property
Public Property Let Key(ByVal value As String)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemKey(m_lID) = value
   End If
End Property

Public Property Get LastSibling() As cTreeViewNode
Attribute LastSibling.VB_Description = "Gets the last sibling node of this item."
Dim ctl As vbalTreeView
Dim lID As Long
   If pbVerify(ctl) Then
      lID = ctl.fItemLastSibling(m_lID)
      If Not (lID = 0) Then
         Dim cNod As New cTreeViewNode
         cNod.fInit ctl, lID
         Set LastSibling = cNod
      End If
   End If
End Property

Public Property Get NextSibling() As cTreeViewNode
Attribute NextSibling.VB_Description = "Gets the next sibling of this item, if any, otherwise returns Nothing."
Dim ctl As vbalTreeView
Dim lIDNext As Long

   If pbVerify(ctl) Then
      lIDNext = ctl.fItemNextSibling(m_lID)
      If Not (lIDNext = 0) Then
         Dim cNod As New cTreeViewNode
         cNod.fInit ctl, lIDNext
         Set NextSibling = cNod
      End If
   End If
End Property

Public Property Get Parent() As cTreeViewNode
Attribute Parent.VB_Description = "Gets the parent node of this node, if any, otherwise returns Nothing."
Dim ctl As vbalTreeView
Dim lIDParent As Long
   If pbVerify(ctl) Then
      lIDParent = ctl.fItemParent(m_lID)
      If Not lIDParent = 0 Then
      Dim cNod As New cTreeViewNode
         cNod.fInit ctl, lIDParent
         Set Parent = cNod
      End If
   End If
End Property

Public Property Get PreviousSibling() As cTreeViewNode
Attribute PreviousSibling.VB_Description = "Gets the previous sibling of this item, if any, otherwise returns Nothing."
Dim ctl As vbalTreeView
Dim lIDNext As Long

   If pbVerify(ctl) Then
      lIDNext = ctl.fItemPreviousSibling(m_lID)
      If Not (lIDNext = 0) Then
         Dim cNod As New cTreeViewNode
         cNod.fInit ctl, lIDNext
         Set NextSibling = cNod
      End If
   End If
End Property

Public Property Get Root() As cTreeViewNode
Attribute Root.VB_Description = "Gets the root node for this node."
Dim ctl As vbalTreeView
Dim lIDRoot As Long
   If pbVerify(ctl) Then
      lIDRoot = ctl.fRootItem()
      Dim cNod As New cTreeViewNode
      cNod.fInit ctl, lIDRoot
      Set Parent = cNod
   End If
End Property

Public Property Get Selected() As Boolean
Attribute Selected.VB_Description = "Gets/sets whether this item is selected or not."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Selected = (ctl.fSelected() = m_lID)
   End If
End Property
Public Property Let Selected(ByVal value As Boolean)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fSelectItem m_lID, value
   End If
End Property

Public Property Get SelectedImage() As Long
Attribute SelectedImage.VB_Description = "Gets/sets the 0-based index of the image in the TreeView's image list to use when the item is selected."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      SelectedImage = ctl.fItemSelectedImage(m_lID)
   End If
End Property
Public Property Let SelectedImage(ByVal value As Long)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemSelectedImage(m_lID) = value
   End If
End Property

Public Property Get ShowPlusMinus() As Boolean
Attribute ShowPlusMinus.VB_Description = "Gets/sets whether the Plus/Minus bitmap should be shown for this item."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ShowPlusMinus = ctl.fItemPlusMinus(m_lID)
   End If
End Property
Public Property Let ShowPlusMinus(ByVal value As Boolean)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemPlusMinus(m_lID) = value
   End If
End Property

Public Property Get Sorted() As Boolean
Attribute Sorted.VB_Description = "Deprecated; has no effect.  Use ChildSortMode or Sort."
   ' TODO
End Property
Public Property Let Sorted(ByVal value As Boolean)
   ' TODO
End Property

Public Sub StartEdit()
Attribute StartEdit.VB_Description = "Programmatically starts editing this node."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemStartEdit m_lID
   End If
End Sub
Public Sub EndEdit(ByVal saveChanges As Boolean)
Attribute EndEdit.VB_Description = "Programmatically ends editing of this node."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemEndEdit m_lID, saveChanges
   End If
End Sub

Public Property Get Tag() As String
Attribute Tag.VB_Description = "Gets/sets a string value associated with this node."
Dim ctl As vbalTreeView
   If (pbVerify(ctl)) Then
      Tag = ctl.fItemTag(m_lID)
   End If
End Property
Public Property Let Tag(ByVal value As String)
Dim ctl As vbalTreeView
   If (pbVerify(ctl)) Then
      ctl.fItemTag(m_lID) = value
   End If
End Property

Public Property Get Text() As String
Attribute Text.VB_Description = "Gets/sets the text for this node."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Text = ctl.fItemText(m_lID)
   End If
End Property
Public Property Let Text(ByVal value As String)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fItemText(m_lID) = value
   End If
End Property

Public Property Get Visible() As Boolean
Attribute Visible.VB_Description = "Gets whether this item is visible in the Tree or not."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      Visible = ctl.fItemVisible(m_lID)
   End If
End Property

Public Property Get top() As Long
Attribute top.VB_Description = "Gets the vertical position of this node within the Tree."
Dim ctl As vbalTreeView
Dim tR As RECT
   If pbVerify(ctl) Then
      ctl.fItemRect m_lID, tR.left, tR.top, tR.right, tR.bottom
      top = tR.top
   End If
End Property
Public Property Get left() As Long
Attribute left.VB_Description = "Gets the horizontal start position of this node."
Dim ctl As vbalTreeView
Dim tR As RECT
   If pbVerify(ctl) Then
      ctl.fItemRect m_lID, tR.left, tR.top, tR.right, tR.bottom
      left = tR.left
   End If
End Property
Public Property Get Width() As Long
Attribute Width.VB_Description = "Gets the width of this node."
Dim ctl As vbalTreeView
Dim tR As RECT
   If pbVerify(ctl) Then
      ctl.fItemRect m_lID, tR.left, tR.top, tR.right, tR.bottom
      Width = (tR.right - tR.left)
   End If
End Property
Public Property Get Height() As Long
Attribute Height.VB_Description = "Gets/sets the height of this item."
Dim ctl As vbalTreeView
Dim tR As RECT
   If pbVerify(ctl) Then
      ctl.fItemRect m_lID, tR.left, tR.top, tR.right, tR.bottom
      Height = (tR.bottom - tR.top)
   End If
End Property

Public Sub Delete()
Attribute Delete.VB_Description = "Deletes this node from the tree."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fRemove m_lID
   End If
End Sub

Public Property Get ChildSortMode() As ETreeViewChildrenSortMode
Attribute ChildSortMode.VB_Description = "Gets/sets the sort mode which should be applied to any children added to this node."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ChildSortMode = ctl.fChildSortMode(m_lID)
   End If
End Property
Public Property Let ChildSortMode(ByVal eMode As ETreeViewChildrenSortMode)
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fChildSortMode(m_lID) = eMode
   End If
End Property
Public Sub Sort(ByVal eMode As ETreeViewChildrenSortMode)
Attribute Sort.VB_Description = "Sorts the child items of this node in the specified style."
Dim ctl As vbalTreeView
   If pbVerify(ctl) Then
      ctl.fSortChildren m_lID, eMode
   End If
End Sub
